/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt;

import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHandler;
import cc.tweaked.internal.cobalt.debug.DebugHelpers;

public class ErrorFactory {
    public static LuaError argError(LuaValue value, String expected) {
        return new LuaError("bad argument (" + expected + " expected, got " + value.typeName() + ")");
    }

    public static LuaError argError(int iarg, String msg) {
        return new LuaError("bad argument #" + iarg + " (" + msg + ")");
    }

    public static LuaError typeError(LuaValue value, String expected) {
        return new LuaError(expected + " expected, got " + value.typeName());
    }

    public static LuaError unimplemented(LuaValue value, String fun) {
        return new LuaError("'" + fun + "' not implemented for " + value.typeName());
    }

    public static LuaError illegal(String op, String typename) {
        return new LuaError("illegal operation '" + op + "' for " + typename);
    }

    public static LuaError arithError(LuaValue value) {
        return new LuaError("attempt to perform arithmetic on " + value.typeName());
    }

    public static LuaError operandError(LuaState state, LuaValue operand, String verb, int stack) {
        DebugFrame info;
        String type = operand.typeName();
        LuaString[] kind = null;
        if (stack >= 0 && (info = DebugHandler.getDebugState(state).getStack()) != null && info.closure != null && stack < info.closure.getPrototype().maxStackSize) {
            kind = DebugHelpers.getObjectName(info, stack);
        }
        if (kind != null) {
            return new LuaError("attempt to " + verb + " " + kind[1] + " '" + kind[0] + "' (a " + type + " value)");
        }
        return new LuaError("attempt to " + verb + " a " + type + " value");
    }

    public static LuaError compareError(LuaValue lhs, LuaValue rhs) {
        return new LuaError("attempt to compare " + lhs.typeName() + " with " + rhs.typeName());
    }

    public static LuaError indexError(LuaValue value) {
        return new LuaError("attempt to index ? (a " + value.typeName() + " value)");
    }
}

